<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="content-Type" content="text/html; charset=UTF-8">
	<title>ID-Rights Demo App</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="Pragma" content="no-cache"/>
	<meta http-equiv="Cache-Control" content="no-cache"/>
	<link rel="SHORTCUT ICON" href="/images/in-groupe-favicon.png"/>
	<link rel="stylesheet" type="text/css" href="/css/global.css"/>
	
</head>
<body>
	<#include "header.ftl">
	
	<div class="content">
		<h1>Get Signature Data response</h1>
		<p class="p1">
			<span>List of roles: For the specified organisation, a list of roles and the holder of the role by name. The function can also be responding with the holder's SSN and address. It is only the name that is shown in this demo app.</span>
			<span>Signature rules: The signing rules for the organisation.</span>
		</p>
		
		<form>
			<span><b>Organisation number: </b>${organizationNo}</span>
			<br/><br/>
			<h5 class="response">List of roles</h5>
			<table class="signstatus">
				<tbody>
					<tr>
						<th>Role</th>
						<th>Name</th>
					</tr>
					<#list roles as role>
						<tr>
							<td> ${role.businessPosition.description}</td>
							<td> ${role.person.name.shortendName}</td>
						</tr>
					</#list>
				</tbody>
			</table>
			<br/>
			<h5 class="response">Signature rules</h5>
			<table class="signstatus">
				<tbody>
					<tr>
						<th>Rule</th>
						<th>Signing right</th>
					</tr>
					<#list signaturelist as signature>
						<tr>
							<td> ${signature.signatureRelationType}</td>
							<td>
								<#list signature.sigAndProcRelations.sigAndProcRelation as spr>
									<span>
										  <#if spr?is_last>
										  	${spr.roleSPRelation.businessPosition.description}
										   <#else>
										   	${spr.roleSPRelation.businessPosition.description} + ', '
										   </#if> 
									</span>
								</#list>
							</td>
						</tr>
					</#list>
				</tbody>
			</table>
			<br/>
			<h5 class="response">Raw Response:</h5>
			<textarea name="rawResponse" class="rawresponse" rows="10" spellcheck="false" ${idrightsresponse}></textarea>
		</form>
		<br/>
	</div>
	<#include "footer.ftl">
</body>
</html>
