/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.common.basics.utils;

import no.bbs.trust.common.basics.events.ActionEvent;
import no.bbs.trust.common.basics.events.Event;
import no.bbs.trust.common.basics.events.MeasurementEvent;
import no.bbs.trust.common.basics.events.PerformanceEvent;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EventLogger {
    private static Logger logger = Logger.getLogger((String)"mainLogger");
    private static final ThreadLocal<StringBuilder> logEventBuffer = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    private static final void appendToString(String string) {
        StringBuilder sb = logEventBuffer.get();
        if (sb.length() > 49152) {
            logger.warn((Object)("Threadlocal stringBuffer for Action/Performanceevents is much larger than expected. It is " + sb.length() + " characters long. This might be a memory leak!"));
        }
        sb.append(string);
    }

    public static final void appendGroupToEvent(Event event, String groupName) {
        if (event == null) {
            logger.info((Object)"Got null as event");
        }
        String eventType = "UNKNWON";
        if (event instanceof ActionEvent) {
            eventType = "AE";
        } else if (event instanceof PerformanceEvent) {
            eventType = "P";
        } else if (event instanceof MeasurementEvent) {
            eventType = "M_";
        }
        EventLogger.appendToString("[GROUP_" + eventType + event.getCode() + "=" + groupName + "]");
    }

    public static final void appendEvent(ActionEvent event) {
        if (event == null) {
            logger.info((Object)"Got null as event");
        }
        String hexCode = event.getCode();
        EventLogger.appendToString("[AE=" + hexCode + "]");
    }

    public static void flush() {
        EventLogger.flush(logger, null);
    }

    public static void flush(Logger logger, String prefix) {
        prefix = prefix == null ? "" : prefix;
        logEventBuffer.get().insert(0, prefix);
        String log = logEventBuffer.get().toString();
        if (log.length() > 0) {
            logger.info((Object)log);
        }
        logEventBuffer.remove();
    }

    public static void flush(String prefix) {
        EventLogger.flush(logger, prefix);
    }

    public static final void appendEvent(MeasurementEvent event, String measure) {
        if (event == null) {
            logger.info((Object)"Got null as event");
        }
        EventLogger.appendToString("[M_" + event.toString() + "=" + measure + "]");
    }

    public static final void appendEvent(PerformanceEvent event, long time) {
        if (event == null) {
            logger.info((Object)"Got null as event");
        }
        String hexCode = event.getCode();
        EventLogger.appendToString("[P" + hexCode + "=" + (System.currentTimeMillis() - time) + "]");
    }

    public static final void dumpStack(Throwable t, Logger logger) {
        if (t != null) {
            EventLogger.dumpStack(t, Level.INFO, logger);
        }
    }

    public static final void dumpStack(Throwable t) {
        if (t != null) {
            EventLogger.dumpStack(t, Level.INFO, logger);
        }
    }

    public static final void dumpStack(Throwable t, String level) {
        if (t != null) {
            EventLogger.dumpStack(t, Level.toLevel((String)level), logger);
        }
    }

    public static final void dumpStack(Throwable t, String level, Logger logger) {
        if (t != null) {
            EventLogger.dumpStack(t, Level.toLevel((String)level), logger);
        }
    }

    public static final void dumpStack(Throwable t, Level level) {
        if (t != null) {
            EventLogger.dumpStack(t, level, logger);
        }
    }

    public static final void dumpStack(Throwable t, Level level, Logger logger) {
        if (t == null) {
            return;
        }
        StackTraceElement[] things = t.getStackTrace();
        logger.log((Priority)level, (Object)t);
        for (int i = 0; i < things.length; ++i) {
            StackTraceElement thing = things[i];
            logger.log((Priority)level, (Object)("\t\tat: " + thing));
        }
        if (t.getCause() != null) {
            logger.log((Priority)level, (Object)"Caused by :");
        }
        EventLogger.dumpStack(t.getCause(), level, logger);
    }
}

