/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.idrights.clientapi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;

public class FileUtil {
    public boolean fileExists(String filepath) {
        File file = new File(filepath);
        return file.exists();
    }

    public String readFileNewLine(String fileName) throws FileNotFoundException, IOException {
        StringBuffer read = new StringBuffer(400);
        try (BufferedReader in = null;){
            in = new BufferedReader(new FileReader(fileName));
            String line = null;
            while ((line = in.readLine()) != null) {
                read.append(line + "\n");
            }
        }
        return read.toString();
    }

    public static InputStream getResourceFromStream(String file) throws FileNotFoundException {
        InputStream in = FileUtil.class.getClassLoader().getResourceAsStream(file);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(file);
        }
        if (null == in) {
            try {
                in = new FileInputStream(new File(file));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            System.out.println("The file " + path + " does not exist. Exiting");
            return null;
        }
        long fileLength = file.length();
        byte[] fileBytes = new byte[(int)fileLength];
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            raf.readFully(fileBytes, 0, (int)fileLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileBytes;
    }

    public String getFileFromStream(String fileName) {
        URL url = this.getClass().getResource("/" + fileName);
        if (null == url) {
            url = this.getClass().getClassLoader().getResource("/" + fileName);
        }
        return url == null ? null : url.getFile();
    }
}

