/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.idrights.clientapi.util;

import eu.nets.sis.idrights.clientapi.config.MerchantContext;
import eu.nets.sis.idrights.clientapi.exception.InvalidConfigurationException;
import java.io.File;

public class ConfigUtil {
    public void validateMerchantContext(MerchantContext mCtx) throws InvalidConfigurationException {
        if (this.isNullOrEmpty(mCtx.getMerchantId())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. MerchantId cannot be null or empty [" + mCtx.getMerchantId() + "]");
        }
        if (this.isNullOrEmpty(mCtx.getDhcConfig().getUrl())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. RMS URL cannot be null or empty");
        }
        if (!mCtx.isSignRequest()) {
            return;
        }
        if (!this.isFileAndExists(mCtx.getDhcConfig().getKeyStorePath())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. KeystorePath [" + mCtx.getDhcConfig().getKeyStorePath() + "] must be a path to a file on the filesystem");
        }
        if (this.isNullOrEmpty(mCtx.getDhcConfig().getKeyStorePwd())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. KeystorePwd cannot be null or empty");
        }
        if (!this.isFileAndExists(mCtx.getDhcConfig().getTrustStore())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. TruststorePath [" + mCtx.getDhcConfig().getTrustStore() + "] must be a path to a file on the filesystem");
        }
        if (this.isNullOrEmpty(mCtx.getDhcConfig().getTrustStorePwd())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. TruststorePwd cannot be null or empty");
        }
        if (this.isNullOrEmpty(mCtx.getDhcConfig().getTrustStoreType())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. TrustStoreType cannot be null or empty");
        }
        if (this.isNullOrEmpty(mCtx.getDhcConfig().getKeyStoreType())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. KeyStoreType cannot be null or empty");
        }
    }

    private boolean isNullOrEmpty(String config) {
        return null == config || "".equals(config);
    }

    private boolean isFileAndExists(String config) {
        if (null == config || "".equals(config)) {
            return false;
        }
        File f = new File(config);
        if (!f.exists()) {
            return false;
        }
        return !f.isDirectory();
    }
}

