/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.idrights.clientapi.impl;

import eu.nets.sis.idrights.clientapi.config.IDRightsError;
import eu.nets.sis.idrights.clientapi.config.MerchantContext;
import eu.nets.sis.idrights.clientapi.exception.IDRightsClientException;
import eu.nets.sis.idrights.clientapi.exception.InvalidConfigurationException;
import eu.nets.sis.idrights.clientapi.impl.IDRightsFacade;
import eu.nets.sis.idrights.clientapi.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Hashtable;

public enum IDRightsFactory {
    INSTANCE;

    private static Hashtable<String, MerchantContext> contexts;

    public void registerMerchantContext(MerchantContext mCtx) throws IDRightsClientException {
        if (null == mCtx) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input MerchantContext is null");
            throw new IDRightsClientException(IDRightsError.IDRIGHTSFACTORY_REGISTER_MERCHANTCONTEXT_FAILED, errparams);
        }
        try {
            ConfigUtil cu = new ConfigUtil();
            cu.validateMerchantContext(mCtx);
        }
        catch (InvalidConfigurationException e) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add(e.getMessage());
            throw new IDRightsClientException(IDRightsError.IDRIGHTSFACTORY_REGISTER_MERCHANTCONTEXT_FAILED, errparams);
        }
        contexts.put(mCtx.getMerchantId(), mCtx);
    }

    public IDRightsFacade getIDRightsFacade(String merchantId) throws IDRightsClientException {
        if (null == merchantId || "".equals(merchantId)) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input MerchantId cannot be null or empty");
            throw new IDRightsClientException(IDRightsError.IDRIGHTSFACTORY_GETIDRIGHTSFACADE_FAILED, errparams);
        }
        MerchantContext ctx = contexts.get(merchantId);
        if (null == ctx) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input MerchantId MerchantContext is not present. Please call registerMerchantContext with the given MerchantId (" + merchantId + ")");
            throw new IDRightsClientException(IDRightsError.IDRIGHTSFACTORY_GETIDRIGHTSFACADE_FAILED, errparams);
        }
        return new IDRightsFacade(ctx);
    }

    static {
        contexts = new Hashtable();
    }
}

