/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.dhc;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import no.bbs.trust.dhc.DHCSSLInitializationError;
import no.bbs.trust.dhc.DHCSSLX509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DHCSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(DHCSSLProtocolSocketFactory.class);
    private static final String[] SSL_ENFORCED_PROTOCOLS = new String[]{"TLSv1", "SSLv3", "TLSv1.1", "TLSv1.2"};
    private URL keystoreUrl = null;
    private String keystorePassword = null;
    private String keystoreType = null;
    private URL truststoreUrl = null;
    private String truststorePassword = null;
    private String truststoreType = null;
    private SSLContext sslcontext = null;
    private int socketTimeoutOverride = 0;

    public DHCSSLProtocolSocketFactory(URL keystoreUrl, String keystorePassword, String keystoreType, URL truststoreUrl, String truststorePassword, String truststoreType, int socketTimeoutOverride) {
        this.keystoreUrl = keystoreUrl;
        this.keystorePassword = keystorePassword;
        this.truststoreUrl = truststoreUrl;
        this.truststorePassword = truststorePassword;
        this.keystoreType = keystoreType;
        this.truststoreType = truststoreType;
        this.socketTimeoutOverride = socketTimeoutOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore createKeyStore(URL url, String password, String keystoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        LOG.debug((Object)"Initializing key store");
        KeyStore keystore = KeyStore.getInstance(keystoreType);
        try (InputStream is = null;){
            is = url.openStream();
            keystore.load(is, password != null ? password.toCharArray() : null);
        }
        return keystore;
    }

    private static KeyManager[] createKeyManagers(KeyStore keystore, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        LOG.debug((Object)"Initializing key manager");
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, password != null ? password.toCharArray() : null);
        return kmfactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore keystore) throws KeyStoreException, NoSuchAlgorithmException {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        LOG.debug((Object)"Initializing trust manager");
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(keystore);
        TrustManager[] trustmanagers = tmfactory.getTrustManagers();
        for (int i = 0; i < trustmanagers.length; ++i) {
            if (!(trustmanagers[i] instanceof X509TrustManager)) continue;
            trustmanagers[i] = new DHCSSLX509TrustManager((X509TrustManager)trustmanagers[i]);
        }
        return trustmanagers;
    }

    private SSLContext createSSLContext() {
        try {
            String alias;
            Enumeration<String> aliases;
            KeyStore keystore;
            KeyManager[] keymanagers = null;
            TrustManager[] trustmanagers = null;
            if (this.keystoreUrl != null) {
                keystore = DHCSSLProtocolSocketFactory.createKeyStore(this.keystoreUrl, this.keystorePassword, this.keystoreType);
                if (LOG.isDebugEnabled()) {
                    aliases = keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        alias = aliases.nextElement();
                        Certificate[] certs = keystore.getCertificateChain(alias);
                        if (certs == null) continue;
                        LOG.debug((Object)("Certificate chain '" + alias + "':"));
                        for (int c = 0; c < certs.length; ++c) {
                            if (!(certs[c] instanceof X509Certificate)) continue;
                            X509Certificate cert = (X509Certificate)certs[c];
                            LOG.debug((Object)(" Certificate " + (c + 1) + ":"));
                            LOG.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                            LOG.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                            LOG.debug((Object)("  Valid from: " + cert.getNotBefore()));
                            LOG.debug((Object)("  Valid until: " + cert.getNotAfter()));
                            LOG.debug((Object)("  Issuer: " + cert.getIssuerDN()));
                        }
                    }
                }
                keymanagers = DHCSSLProtocolSocketFactory.createKeyManagers(keystore, this.keystorePassword);
            }
            if (this.truststoreUrl != null) {
                keystore = DHCSSLProtocolSocketFactory.createKeyStore(this.truststoreUrl, this.truststorePassword, this.truststoreType);
                if (LOG.isDebugEnabled()) {
                    aliases = keystore.aliases();
                    while (aliases.hasMoreElements()) {
                        alias = aliases.nextElement();
                        LOG.debug((Object)("Trusted certificate '" + alias + "':"));
                        Certificate trustedcert = keystore.getCertificate(alias);
                        if (trustedcert == null || !(trustedcert instanceof X509Certificate)) continue;
                        X509Certificate cert = (X509Certificate)trustedcert;
                        LOG.debug((Object)("  Subject DN: " + cert.getSubjectDN()));
                        LOG.debug((Object)("  Signature Algorithm: " + cert.getSigAlgName()));
                        LOG.debug((Object)("  Valid from: " + cert.getNotBefore()));
                        LOG.debug((Object)("  Valid until: " + cert.getNotAfter()));
                        LOG.debug((Object)("  Issuer: " + cert.getIssuerDN()));
                    }
                }
                trustmanagers = DHCSSLProtocolSocketFactory.createTrustManagers(keystore);
            }
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(keymanagers, trustmanagers, null);
            return context;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new DHCSSLInitializationError("Unsupported algorithm exception: " + e.getMessage());
        }
        catch (KeyStoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new DHCSSLInitializationError("Keystore exception: " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new DHCSSLInitializationError("Key management exception: " + e.getMessage());
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new DHCSSLInitializationError("I/O error reading keystore/truststore file: " + e.getMessage());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    private Socket enforceSSLProtocols(Socket socket) {
        if (!(socket instanceof SSLSocket)) {
            return socket;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        sslSocket.setEnabledProtocols(SSL_ENFORCED_PROTOCOLS);
        return sslSocket;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (this.socketTimeoutOverride > 0) {
            timeout = this.socketTimeoutOverride;
        }
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            return this.enforceSSLProtocols(socketfactory.createSocket(host, port, localAddress, localPort));
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return this.enforceSSLProtocols(socket);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.enforceSSLProtocols(this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort));
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.enforceSSLProtocols(this.getSSLContext().getSocketFactory().createSocket(host, port));
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.enforceSSLProtocols(this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose));
    }
}

