/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEUtil;

public class SMIMESignedParser
extends CMSSignedDataParser {
    Object message;
    MimeBodyPart content;

    private static InputStream getInputStream(Part part) throws MessagingException {
        try {
            if (part.isMimeType("multipart/signed")) {
                throw new MessagingException("attempt to create signed data object from multipart content - use MimeMultipart constructor.");
            }
            return part.getInputStream();
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    private static File getTmpFile() throws MessagingException {
        try {
            return File.createTempFile("bcMail", ".mime");
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    private static CMSTypedStream getSignedInputStream(BodyPart bodyPart, String string, File file) throws MessagingException {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            SMIMEUtil.outputBodyPart(bufferedOutputStream, bodyPart, string);
            ((OutputStream)bufferedOutputStream).close();
            TemporaryFileInputStream temporaryFileInputStream = new TemporaryFileInputStream(file);
            return new CMSTypedStream(temporaryFileInputStream);
        }
        catch (IOException iOException) {
            throw new MessagingException("can't extract input stream: " + iOException);
        }
    }

    public SMIMESignedParser(MimeMultipart mimeMultipart) throws MessagingException, CMSException {
        this(mimeMultipart, SMIMESignedParser.getTmpFile());
    }

    public SMIMESignedParser(MimeMultipart mimeMultipart, File file) throws MessagingException, CMSException {
        this(mimeMultipart, "7bit", file);
    }

    public SMIMESignedParser(MimeMultipart mimeMultipart, String string) throws MessagingException, CMSException {
        this(mimeMultipart, string, SMIMESignedParser.getTmpFile());
    }

    public SMIMESignedParser(MimeMultipart mimeMultipart, String string, File file) throws MessagingException, CMSException {
        super(SMIMESignedParser.getSignedInputStream(mimeMultipart.getBodyPart(0), string, file), SMIMESignedParser.getInputStream((Part)mimeMultipart.getBodyPart(1)));
        this.message = mimeMultipart;
        this.content = (MimeBodyPart)mimeMultipart.getBodyPart(0);
        this.drainContent();
    }

    public SMIMESignedParser(Part part) throws MessagingException, CMSException, SMIMEException {
        super(SMIMESignedParser.getInputStream(part));
        this.message = part;
        CMSTypedStream cMSTypedStream = this.getSignedContent();
        if (cMSTypedStream != null) {
            this.content = SMIMEUtil.toWriteOnceBodyPart(cMSTypedStream);
        }
    }

    public SMIMESignedParser(Part part, File file) throws MessagingException, CMSException, SMIMEException {
        super(SMIMESignedParser.getInputStream(part));
        this.message = part;
        CMSTypedStream cMSTypedStream = this.getSignedContent();
        if (cMSTypedStream != null) {
            this.content = SMIMEUtil.toMimeBodyPart(cMSTypedStream, file);
        }
    }

    public MimeBodyPart getContent() {
        return this.content;
    }

    public MimeMessage getContentAsMimeMessage(Session session) throws MessagingException, IOException {
        if (this.message instanceof MimeMultipart) {
            BodyPart bodyPart = ((MimeMultipart)this.message).getBodyPart(0);
            return new MimeMessage(session, bodyPart.getInputStream());
        }
        return new MimeMessage(session, this.getSignedContent().getContentStream());
    }

    public Object getContentWithSignature() {
        return this.message;
    }

    private void drainContent() throws CMSException {
        try {
            this.getSignedContent().drain();
        }
        catch (IOException iOException) {
            throw new CMSException("unable to read content for verification: " + iOException, iOException);
        }
    }

    static {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        CommandMap.setDefaultCommandMap(mailcapCommandMap);
    }

    private static class TemporaryFileInputStream
    extends BufferedInputStream {
        private final File _file;

        TemporaryFileInputStream(File file) throws FileNotFoundException {
            super(new FileInputStream(file));
            this._file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._file.delete();
        }
    }
}

