/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.b2b.xmlapi.message;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;
import no.bbs.trust.b2b.xmlapi.message.SchemaRepo;
import no.bbs.trust.b2b.xmlapi.message.domain.B2BMessage;
import no.bbs.trust.b2b.xmlapi.message.generated.TrustB2BMessage;
import no.bbs.trust.common.basics.utils.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Unmarshaller {
    private final Logger logger = LogManager.getLogger("mainLogger");
    private final JAXBContext jaxbContext;
    public final String startTag = "<B64XmlRequest>";
    public final String endTag = "</B64XmlRequest>";
    public final String startTidTag = "<TransID>";
    public final String endTidTag = "</TransID>";
    public final String startTraceidTag = "<TraceID>";
    public final String endTraceidTag = "</TraceID>";
    public final String startCountry = "<CountryCode>";
    public final String endCountry = "</CountryCode>";
    public final String startMessageID = "<MessageID>";
    public final String endMessageID = "</MessageID>";
    public final String startMerchantID = "<MerchantID>";
    public final String endMerchantID = "</MerchantID>";
    public static final Unmarshaller instance = new Unmarshaller();
    private final String startSchema = "xmlns=\"";
    private final String endSchema = "tb2b#";

    private Unmarshaller() {
        try {
            this.jaxbContext = JAXBContext.newInstance("no.bbs.trust.b2b.xmlapi.message.generated");
        }
        catch (JAXBException je) {
            throw new RuntimeException(je);
        }
    }

    public B2BMessage unmarshall(String xml) throws JAXBException, UnsupportedEncodingException {
        String tid = this.extractTid(xml);
        String content = this.extractB2BContent(xml);
        String schemaID = this.extractSchemaVersion(content);
        javax.xml.bind.Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        Schema schema = SchemaRepo.getSchema(schemaID);
        unmarshaller.setSchema(schema);
        B2BMessage b2bMessage = new B2BMessage((TrustB2BMessage)unmarshaller.unmarshal(new StringReader(content)), tid);
        b2bMessage.setSchema(schema);
        return b2bMessage;
    }

    public TrustB2BMessage unmarshallTrustB2BMessage(String xml) throws JAXBException, UnsupportedEncodingException {
        String schemaID = this.extractSchemaVersion(xml);
        javax.xml.bind.Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        Schema schema = SchemaRepo.getSchema(schemaID);
        unmarshaller.setSchema(schema);
        TrustB2BMessage messageResponse = (TrustB2BMessage)unmarshaller.unmarshal(new StringReader(xml));
        return messageResponse;
    }

    public B2BMessage unmarshallB2BMessage(String content) throws JAXBException {
        String schemaID = this.extractSchemaVersion(content);
        Schema schema = SchemaRepo.getSchema(schemaID);
        javax.xml.bind.Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        unmarshaller.setSchema(schema);
        TrustB2BMessage message = (TrustB2BMessage)unmarshaller.unmarshal(new StringReader(content));
        B2BMessage b2bMessage = new B2BMessage(message, message.getTrustB2BHeader().getTraceID());
        b2bMessage.setSchema(schema);
        return b2bMessage;
    }

    public String extractTid(String xml) {
        try {
            return xml.substring(xml.indexOf("<TransID>") + "<TransID>".length(), xml.indexOf("</TransID>"));
        }
        catch (Exception e) {
            this.logger.warn("[ERR1=] [ERR2=Error in requestmessage - the system sending the request must fix this - most likely RMS]");
            return "0";
        }
    }

    public String extractInternalTid(String xml) {
        try {
            return xml.substring(xml.indexOf("<TraceID>") + "<TraceID>".length(), xml.indexOf("</TraceID>"));
        }
        catch (Exception e) {
            this.logger.warn("[ERR1=] [ERR2=Error in requestmessage - the system sending the request must fix this - most likely some component in TrustSign]");
            return "0";
        }
    }

    public String extractB2BContent(String xml) throws UnsupportedEncodingException {
        String b64Content = xml.substring(xml.indexOf("<B64XmlRequest>") + "<B64XmlRequest>".length(), xml.indexOf("</B64XmlRequest>"));
        return Base64.decode(b64Content, "UTF-8");
    }

    public String extractSchemaVersion(String xml) {
        int start = xml.indexOf("xmlns=\"");
        int end = xml.indexOf("tb2b#", start);
        return xml.substring(start + "xmlns=\"".length(), end + "tb2b#".length());
    }

    public String extractCountry(String xml) {
        String content = xml.substring(xml.indexOf("<CountryCode>") + "<CountryCode>".length(), xml.indexOf("</CountryCode>"));
        return content;
    }

    public long extractMid(String xml) {
        String content = xml.substring(xml.indexOf("<MerchantID>") + "<MerchantID>".length(), xml.indexOf("</MerchantID>"));
        try {
            return Long.parseLong(content);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public String extractMessageID(String xml) {
        String content = xml.substring(xml.indexOf("<MessageID>") + "<MessageID>".length(), xml.indexOf("</MessageID>"));
        return content;
    }
}

