document.addEventListener("DOMContentLoaded", function() {
	let popupBtn = document.getElementById("open-popup-button");
	let standaloneBtn = document.getElementById("open-standalone-button");
	
	popupBtn.addEventListener("click", onPopupBtnClicked);
	standaloneBtn.addEventListener("click", onStandaloneBtnClicked);
});

window.addEventListener("focus", keepPopupInFocus);
window.addEventListener("click", keepPopupInFocus); // Workaround for Firefox

const CONTEXT_PATH = "/demoapp";
let popup;
let eSignUrl;
let isPopup = false;
let xmlHttp = new XMLHttpRequest();

function keepPopupInFocus() {
	if (popup && !popup.closed) {
    	popup.focus();
    }
}

function openCenteredPopup() {
	let width = 700;
    let height = 950;
    let x = window.outerWidth/2 - width/2 + window.screenX;
    let y = window.outerHeight/2 - height/2 + window.screenY;
    openPopup(x, y, width, height);
}

function openPopup(x, y, width, height) {
	popup = window.open(eSignUrl, "esign", "width=" + width + ",height=" + height + ",top=" + y + ",left=" + x);
}

function onPopupBtnClicked() {
	isPopup = true;
	setPopupSelection();
}

function onStandaloneBtnClicked() {
	isPopup = false;
	setPopupSelection();
}

function setPopupSelection() {
	let url = CONTEXT_PATH + '?ispopup=' + isPopup;
	xmlHttp.onreadystatechange = getSignUrl;
	xmlHttp.open("POST", url, true);
	xmlHttp.send(null);
}

function getSignUrl() {
	if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete") {
		let docType = document.querySelector('input[name="doctype"]:checked').value;
		let url = CONTEXT_PATH + '?doctype=' + docType;
		xmlHttp.onreadystatechange = loadSignUrl;
		xmlHttp.open("POST", url, true);
		xmlHttp.send(null);
	}
}

function loadSignUrl() {
	if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete") {
		eSignUrl = xmlHttp.response;
		
		if (eSignUrl == "error") {
			location.href = window.location.href + "?status=error";
			return;
		}
		
		if  (isPopup) {
			openCenteredPopup();
		} else {
			location.href = eSignUrl; //Standalone UI
		}
	}
}