package eu.nets.sis.esign.demoapp;

import java.io.IOException;

import eu.nets.sis.esign.demoapp.startup.ServerSetup;
import eu.nets.sis.esign.demoapp.service.DemoAppService;

/**
 * Application entry point
 * 
 */
public class MainApplication {
	public static void main(String[] args) throws IOException {
		if (args.length < 2 || !args[0].toLowerCase().endsWith("p12")) {
			System.out.println(
					"\n\nERROR: Please provide a valid keystore (PKCS12) path and a password as command line arguments to execute the demo app. "
							+ "Contact IN Groupe support at trustservices@ingroupe.com for details.\n");
		} else {
			if (ServerSetup.isPortAvailable()) {
				DemoAppService.registerMerchantContext(args[0], args[1]);
				new ServerSetup().start();
			} else {
				System.out.println("\n\nThe demo application cannot be started. Port " + DemoAppProperties.port + " is already in use.\nMake sure no other applications is configured to use this port and try again.");
			}
		}
	}
}
