/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import no.bbs.tt.trustsign.tsm.xml.error.TSMException;
import no.bbs.tt.trustsign.tsm.xml.errorhandler.TSMDefaultErrorHandler;
import no.bbs.tt.trustsign.tsm.xml.util.SecureDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static String getSchemalocationAttr(String xml) throws TSMException {
        try {
            DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            parser.setErrorHandler(new TSMDefaultErrorHandler());
            InputSource is = new InputSource(new StringReader(xml));
            Document dom = parser.parse(is);
            Element root = dom.getDocumentElement();
            if (root == null) {
                String errmsg = "Failed to get schemalocation attribute value from input xml. Reason: Could not find root Element";
                throw new TSMException(errmsg);
            }
            NamedNodeMap attributes = root.getAttributes();
            String schemaLocation = null;
            if (attributes == null) {
                String errmsg = "Failed to get schemalocation attribute value from input xml. Reason: Could not find any attributes in root Element";
                throw new TSMException(errmsg);
            }
            String schemaLocationAttribute = "xsi:schemaLocation";
            Node schemaLocationNode = attributes.getNamedItem(schemaLocationAttribute);
            if (null == schemaLocationNode) {
                String errmsg = "Failed to get schemalocation attribute value from input xml. Reason: Could not find schemaLocation attribute in root Element";
                throw new TSMException(errmsg);
            }
            schemaLocation = schemaLocationNode.getNodeValue();
            if (null == schemaLocation || "".equals(schemaLocation)) {
                String errmsg = "Failed to get valid schemalocation attribute value from input xml. Reason: schemalocation attribute is null or empty";
                throw new TSMException(errmsg);
            }
            return schemaLocation;
        }
        catch (TSMException e) {
            throw e;
        }
        catch (Exception e) {
            String errmsg = "Failed to get schemalocation attribute value from input xml. Reason: " + e.getMessage();
            throw new TSMException(errmsg);
        }
    }

    public static String getNamespaceAttrValue(String xml) throws TSMException {
        try {
            NamedNodeMap nodeAttributes;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = dbf.newDocumentBuilder();
            parser.setErrorHandler(new TSMDefaultErrorHandler());
            InputSource is = new InputSource(new StringReader(xml));
            Document document = parser.parse(is);
            Element root = document.getDocumentElement();
            if (root == null) {
                String errmsg = "Failed to get namespace attribute value from input xml. Reason: Could not find root Element";
                throw new TSMException(errmsg);
            }
            String namespaceURI = root.getNamespaceURI();
            String namespace = null;
            if (null == namespace && (nodeAttributes = root.getAttributes()) != null) {
                Node nsNode;
                Object nsAttr = "xmlns";
                if (null != namespaceURI) {
                    nsAttr = (String)nsAttr + ":" + namespaceURI;
                }
                if (null != (nsNode = nodeAttributes.getNamedItem((String)nsAttr)) && null == (namespace = nsNode.getNodeValue())) {
                    String errmsg = "Failed to get namespace from input xml. Namespace attribute is not present";
                    throw new TSMException(errmsg);
                }
            }
            return namespace;
        }
        catch (TSMException e) {
            throw e;
        }
        catch (Exception e) {
            String errmsg = "Failed to get namespace from input xml. Reason: " + e.getMessage();
            throw new TSMException(errmsg);
        }
    }

    public static String removeTagData(String tagName, String xmlReq, String replaceString) {
        String startTag = "<" + tagName + ">";
        String endTag = "</" + tagName + ">";
        int tagLength = startTag.length();
        int endTagLength = endTag.length();
        String tail = xmlReq;
        StringBuffer xmlParts = new StringBuffer();
        if (xmlReq.indexOf(startTag) > 0) {
            while (tail.indexOf(startTag) > 0) {
                xmlParts.append(tail.substring(0, tail.indexOf(startTag) + tagLength));
                int indexOfEndTag = tail.indexOf(endTag);
                if (null != replaceString) {
                    xmlParts.append(replaceString);
                }
                xmlParts.append(endTag);
                tail = new String(tail.substring(indexOfEndTag + endTagLength));
            }
            xmlParts.append(tail);
            xmlReq = xmlParts.toString();
        }
        return xmlReq;
    }

    public static Document parse(String filename) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputStream stream = XMLUtil.class.getClassLoader().getResourceAsStream(filename);
        return db.parse(stream);
    }
}

