/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Archive;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Step;
import no.bbs.tt.trustsign.tsm.xml.statics.DisplayProcessInfo;
import no.bbs.tt.trustsign.tsm.xml.util.DateUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExecutionDetails
implements Serializable {
    private static final long serialVersionUID = 4592915885416823215L;
    private Date orderDeadline = null;
    private String displayProcessInfo = DisplayProcessInfo.NO;
    private boolean generateOneTimeURLs = false;
    private ArrayList<Step> steps = null;
    private Archive archive = null;
    private String outputFormat = null;

    public ExecutionDetails() {
    }

    public ExecutionDetails(Element element) {
        Element stepsELem;
        NodeList stepElements;
        String generateOTU;
        NodeList nl = element.getElementsByTagName("OrderDeadline");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setOrderDeadline(DateUtility.XMLToDate(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = element.getElementsByTagName("DisplayProcessInfo")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setDisplayProcessInfo(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("GenerateOneTimeURLs")).getLength() > 0 && nl.item(0).getFirstChild() != null && "true".equalsIgnoreCase(generateOTU = nl.item(0).getFirstChild().getNodeValue())) {
            this.setGenerateOneTimeURLs(true);
        }
        if ((nl = element.getElementsByTagName("Steps")).getLength() > 0 && (stepElements = (stepsELem = (Element)nl.item(0)).getElementsByTagName("Step")).getLength() > 0) {
            this.steps = new ArrayList();
            for (int i = 0; i < stepElements.getLength(); ++i) {
                Element currStep = (Element)stepElements.item(i);
                this.steps.add(new Step(currStep));
            }
        }
        if ((nl = element.getElementsByTagName("Archive")).getLength() > 0) {
            this.setArchive(new Archive((Element)nl.item(0)));
        }
        if ((nl = element.getElementsByTagName("OutputFormat")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setOutputFormat(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public Element toXML(Document doc) {
        Element childElement;
        Element root = doc.createElement("ExecutionDetails");
        if (null != this.getOrderDeadline()) {
            childElement = doc.createElement("OrderDeadline");
            childElement.appendChild(doc.createTextNode(DateUtility.DateToXML(this.getOrderDeadline())));
            root.appendChild(childElement);
        }
        if (null != this.getDisplayProcessInfo()) {
            childElement = doc.createElement("DisplayProcessInfo");
            childElement.appendChild(doc.createTextNode(this.getDisplayProcessInfo()));
            root.appendChild(childElement);
        }
        if (this.generateOneTimeURLs()) {
            Element gotuElement = doc.createElement("GenerateOneTimeURLs");
            gotuElement.appendChild(doc.createTextNode("true"));
            root.appendChild(gotuElement);
        }
        if (null != this.getSteps() && !this.getSteps().isEmpty()) {
            Element stepsElement = doc.createElement("Steps");
            for (int i = 0; i < this.getSteps().size(); ++i) {
                Step curStep = this.getSteps().get(i);
                stepsElement.appendChild(curStep.toXML(doc));
            }
            root.appendChild(stepsElement);
        }
        if (null != this.getArchive()) {
            root.appendChild(this.getArchive().toXML(doc));
        }
        if (null != this.getOutputFormat()) {
            childElement = doc.createElement("OutputFormat");
            childElement.appendChild(doc.createTextNode(this.getOutputFormat()));
            root.appendChild(childElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public Date getOrderDeadline() {
        return this.orderDeadline;
    }

    public void setOrderDeadline(Date orderDeadline) {
        this.orderDeadline = orderDeadline;
    }

    public String getDisplayProcessInfo() {
        return this.displayProcessInfo;
    }

    public void setDisplayProcessInfo(String displayProcessInfo) {
        this.displayProcessInfo = displayProcessInfo;
    }

    public boolean generateOneTimeURLs() {
        return this.generateOneTimeURLs;
    }

    public void setGenerateOneTimeURLs(boolean generateOneTimeURLs) {
        this.generateOneTimeURLs = generateOneTimeURLs;
    }

    public ArrayList<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(ArrayList<Step> steps) {
        this.steps = steps;
    }

    public void addStep(Step s) {
        if (null == this.steps) {
            this.steps = new ArrayList();
        }
        this.steps.add(s);
    }

    public Archive getArchive() {
        return this.archive;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }
}

