/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages;

import no.bbs.tt.trustsign.tsm.xml.messages.BaseResponseMessage;
import no.bbs.tt.trustsign.tsm.xml.messages.TrustSignMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ErrorResponse
extends BaseResponseMessage {
    private static final long serialVersionUID = -5155400456887268784L;
    private String errorCode;
    private String errorText;

    public ErrorResponse() {
        this.setMessageID("NA");
    }

    public ErrorResponse(Document document) {
        super(document);
        this.setMessageID("NA");
        NodeList nl = document.getElementsByTagName("ErrorCode");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setErrorCode(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = document.getElementsByTagName("ErrorText")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setErrorText(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public ErrorResponse(TrustSignMessage message, String errorCode, String errorText) {
        this.setMerchantID(message.getMerchantID());
        this.setOrderID(message.getOrderID());
        this.setTransRef(message.getTransRef());
        this.setNamespace(message.getNamespace());
        this.errorCode = errorCode;
        this.errorText = errorText;
        this.setType("ErrorResponse");
    }

    public ErrorResponse(int merchantId, String orderId, String errorCode, String errorText, String transRef, String namespace) {
        this.setMerchantID(merchantId);
        this.setOrderID(orderId);
        this.setTransRef(transRef);
        this.errorCode = errorCode;
        this.errorText = errorText;
        this.setNamespace(namespace);
        this.setType("ErrorResponse");
    }

    public ErrorResponse(String errorCode, String errorText, String transRef, String namespace) {
        this.setTransRef(transRef);
        this.errorCode = errorCode;
        this.errorText = errorText;
        this.setNamespace(namespace);
        this.setType("ErrorResponse");
    }

    @Override
    public Document toXML() {
        Document localDoc = super.toXML();
        Element root = this.toXMLHeader("ErrorResponse", localDoc);
        Element childElement = null;
        if (this.getErrorCode() != null) {
            childElement = localDoc.createElement("ErrorCode");
            childElement.appendChild(localDoc.createTextNode(this.getErrorCode()));
            root.appendChild(childElement);
        }
        if (this.getErrorText() != null) {
            childElement = localDoc.createElement("ErrorText");
            childElement.appendChild(localDoc.createTextNode(this.getErrorText()));
            root.appendChild(childElement);
        }
        localDoc.getFirstChild().appendChild(root);
        return localDoc;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }
}

