/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.esignclientapi.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import no.bbs.trust.esignclientapi.exception.ESignClientException;
import no.bbs.trust.esignclientapi.exception.InvalidConfigurationException;
import no.bbs.trust.esignclientapi.impl.ESigningFacade;
import no.bbs.trust.esignclientapi.impl.MerchantContext;
import no.bbs.trust.esignclientapi.statics.ESignError;
import no.bbs.trust.esignclientapi.statics.ESignNamespace;
import no.bbs.trust.esignclientapi.util.ConfigUtil;
import no.bbs.trust.esignclientapi.util.FileUtil;

public enum ESigningFactory {
    INSTANCE;

    private static Hashtable<String, MerchantContext> contexts;
    private boolean isXsdDirSet = false;
    private static String XSD_DIRECTORY;

    protected void detectXsdDir() throws ESignClientException {
        if (this.isXsdDirSet) {
            return;
        }
        try {
            ESignNamespace[] configuredNamespaces;
            FileUtil fu = new FileUtil();
            for (ESignNamespace ns : configuredNamespaces = ESignNamespace.values()) {
                String nsXsdPath = fu.getFileFromStream(ns.getXsd());
                if (null == nsXsdPath) continue;
                XSD_DIRECTORY = nsXsdPath.substring(0, nsXsdPath.lastIndexOf("/") + 1);
            }
            System.out.println("XSD_DIRECTORY: [" + XSD_DIRECTORY + "]");
            this.isXsdDirSet = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Error occured seraching for esignclientapi xsd directory: " + t.getMessage());
            throw new ESignClientException(ESignError.ESIGNFACTORY_REGISTER_MERCHANTCONTEXT_FAILED, errparams);
        }
    }

    public void registerMerchantContext(MerchantContext mCtx) throws ESignClientException {
        if (null == mCtx) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input MerchantContext is null");
            throw new ESignClientException(ESignError.ESIGNFACTORY_REGISTER_MERCHANTCONTEXT_FAILED, errparams);
        }
        try {
            ConfigUtil cu = new ConfigUtil();
            cu.validateMerchantContext(mCtx);
        }
        catch (InvalidConfigurationException e) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add(e.getMessage());
            throw new ESignClientException(ESignError.ESIGNFACTORY_REGISTER_MERCHANTCONTEXT_FAILED, errparams);
        }
        contexts.put(mCtx.getMerchantName(), mCtx);
    }

    public ESigningFacade getESigningFacade(String merchantName) throws ESignClientException {
        if (null == merchantName || "".equals(merchantName)) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input merchantName cannot be null or empty");
            throw new ESignClientException(ESignError.ESIGNFACTORY_GETESIGNFACADE_FAILED, errparams);
        }
        MerchantContext ctx = contexts.get(merchantName);
        if (null == ctx) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input merchantName MerchantContext is not present. Please call registerMerchantContext with the given MerchantName (" + merchantName + ")");
            throw new ESignClientException(ESignError.ESIGNFACTORY_GETESIGNFACADE_FAILED, errparams);
        }
        return new ESigningFacade(ctx);
    }

    static {
        contexts = new Hashtable();
        XSD_DIRECTORY = null;
    }
}

