/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.esignclientapi.ds;

import java.io.ByteArrayOutputStream;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import no.bbs.trust.esignclientapi.p12.PKCS12Keystore;
import no.bbs.trust.esignclientapi.util.String2Document;
import no.bbs.tt.trustsign.tsm.xml.util.SecureDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLSigner {
    private XMLSignatureFactory fac;
    private KeyInfoFactory kif;
    private KeyInfo ki;
    private Reference ref;
    private PKCS12Keystore sks;

    public XMLSigner(PKCS12Keystore sks) throws InstantiationException {
        if (null == sks) {
            throw new InstantiationException("Unable to instantiate XMLSigner. Input PKCS12Keystore is null.");
        }
        if (null == sks.getPrivateKey()) {
            throw new InstantiationException("Unable to instantiate XMLSigner. Could not get the private key from input PKCS12Keystore.");
        }
        this.sks = sks;
        try {
            String providerName = System.getProperty("jsr105Provider");
            this.fac = providerName != null ? XMLSignatureFactory.getInstance("DOM", providerName) : XMLSignatureFactory.getInstance("DOM");
            this.kif = this.fac.getKeyInfoFactory();
        }
        catch (NoSuchProviderException e) {
            throw new InstantiationException("Unable to instantiate XMLSigner. Could not load Provider(jsr105Provider). Check java security/policy settings. :" + e.getMessage());
        }
    }

    public X509Certificate getSignerCertificate() {
        return this.sks.getLeafCertificate();
    }

    public String signXML(String xmlAsString) throws SignatureException {
        try {
            Document doc;
            X509Certificate cert = this.getSignerCertificate();
            X509Data x5 = this.kif.newX509Data(Collections.nCopies(1, cert));
            this.ki = this.kif.newKeyInfo(Collections.nCopies(1, x5));
            this.ref = this.fac.newReference("#object", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            String2Document s2d = new String2Document();
            try {
                doc = s2d.createDocumentFromString(xmlAsString);
            }
            catch (Exception e) {
                throw new SignatureException("XMLSigner.signXML failed. Could not create an XML Document from input XML string", e);
            }
            if (null == doc.getDocumentElement()) {
                throw new SignatureException("XMLSigner.signXML. Input XML Document is empty.");
            }
            DOMStructure content = new DOMStructure(doc.getFirstChild());
            return this.signXML(content);
        }
        catch (Exception e) {
            throw new SignatureException("XMLSigner.signXml failed. Reason: " + e.getMessage());
        }
    }

    private String signXML(XMLStructure content) throws Exception {
        XMLObject obj = this.fac.newXMLObject(Collections.nCopies(1, content), "object", null, null);
        SignedInfo si = this.fac.newSignedInfo(this.fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.nCopies(1, this.ref));
        XMLSignature signature = this.fac.newXMLSignature(si, this.ki, Collections.nCopies(1, obj), null, null);
        DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        DOMSignContext dsc = new DOMSignContext(this.sks.getPrivateKey(), (Node)doc);
        signature.sign(dsc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        os.flush();
        String res = new String(os.toByteArray(), "UTF-8");
        os.close();
        return res;
    }
}

