/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import com.sun.org.apache.xalan.internal.xsltc.trax.SAX2StAXBaseWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

public class SAX2StAXEventWriter
extends SAX2StAXBaseWriter {
    private XMLEventWriter writer;
    private XMLEventFactory eventFactory;
    private List namespaceStack = new ArrayList();
    private boolean needToCallStartDocument = false;

    public SAX2StAXEventWriter() {
        this.eventFactory = XMLEventFactory.newInstance();
    }

    public SAX2StAXEventWriter(XMLEventWriter writer) {
        this.writer = writer;
        this.eventFactory = XMLEventFactory.newInstance();
    }

    public SAX2StAXEventWriter(XMLEventWriter writer, XMLEventFactory factory) {
        this.writer = writer;
        this.eventFactory = factory != null ? factory : XMLEventFactory.newInstance();
    }

    public XMLEventWriter getEventWriter() {
        return this.writer;
    }

    public void setEventWriter(XMLEventWriter writer) {
        this.writer = writer;
    }

    public XMLEventFactory getEventFactory() {
        return this.eventFactory;
    }

    public void setEventFactory(XMLEventFactory factory) {
        this.eventFactory = factory;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.namespaceStack.clear();
        this.eventFactory.setLocation(this.getCurrentLocation());
        this.needToCallStartDocument = true;
    }

    public void endDocument() throws SAXException {
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.writer.add(this.eventFactory.createEndDocument());
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
        super.endDocument();
        this.namespaceStack.clear();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.needToCallStartDocument) {
            try {
                if (this.docLocator == null) {
                    this.writer.add(this.eventFactory.createStartDocument());
                } else {
                    try {
                        this.writer.add(this.eventFactory.createStartDocument(((Locator2)this.docLocator).getEncoding(), ((Locator2)this.docLocator).getXMLVersion()));
                    }
                    catch (ClassCastException e) {
                        this.writer.add(this.eventFactory.createStartDocument());
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
            this.needToCallStartDocument = false;
        }
        this.eventFactory.setLocation(this.getCurrentLocation());
        Collection[] events = new Collection[]{null, null};
        this.createStartEvents(attributes, events);
        this.namespaceStack.add(events[0]);
        try {
            String[] qname = new String[]{null, null};
            SAX2StAXEventWriter.parseQName(qName, qname);
            this.writer.add(this.eventFactory.createStartElement(qname[0], uri, qname[1], events[1].iterator(), events[0].iterator()));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        this.eventFactory.setLocation(this.getCurrentLocation());
        String[] qname = new String[]{null, null};
        SAX2StAXEventWriter.parseQName(qName, qname);
        Collection nsList = (Collection)this.namespaceStack.remove(this.namespaceStack.size() - 1);
        Iterator nsIter = nsList.iterator();
        try {
            this.writer.add(this.eventFactory.createEndElement(qname[0], uri, qname[1], nsIter));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        super.comment(ch, start, length);
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.writer.add(this.eventFactory.createComment(new String(ch, start, length)));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        try {
            if (!this.isCDATA) {
                this.eventFactory.setLocation(this.getCurrentLocation());
                this.writer.add(this.eventFactory.createCharacters(new String(ch, start, length)));
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        super.processingInstruction(target, data);
        try {
            this.writer.add(this.eventFactory.createProcessingInstruction(target, data));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void endCDATA() throws SAXException {
        this.eventFactory.setLocation(this.getCurrentLocation());
        try {
            this.writer.add(this.eventFactory.createCData(this.CDATABuffer.toString()));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
        super.endCDATA();
    }

    protected void createStartEvents(Attributes attributes, Collection[] events) {
        int i;
        HashMap<String, Namespace> nsMap = null;
        ArrayList<Attribute> attrs = null;
        if (this.namespaces != null) {
            int nDecls = this.namespaces.size();
            for (i = 0; i < nDecls; ++i) {
                String prefix = (String)this.namespaces.elementAt(i);
                String uri = (String)this.namespaces.elementAt(i++);
                Namespace ns = this.createNamespace(prefix, uri);
                if (nsMap == null) {
                    nsMap = new HashMap<String, Namespace>();
                }
                nsMap.put(prefix, ns);
            }
        }
        String[] qname = new String[]{null, null};
        int s = attributes.getLength();
        for (i = 0; i < s; ++i) {
            SAX2StAXEventWriter.parseQName(attributes.getQName(i), qname);
            String attrPrefix = qname[0];
            String attrLocal = qname[1];
            String attrQName = attributes.getQName(i);
            String attrValue = attributes.getValue(i);
            String attrURI = attributes.getURI(i);
            if ("xmlns".equals(attrQName) || "xmlns".equals(attrPrefix)) {
                if (nsMap.containsKey(attrPrefix)) continue;
                Namespace ns = this.createNamespace(attrPrefix, attrValue);
                if (nsMap == null) {
                    nsMap = new HashMap();
                }
                nsMap.put(attrPrefix, ns);
                continue;
            }
            Attribute attribute = attrPrefix.length() > 0 ? this.eventFactory.createAttribute(attrPrefix, attrURI, attrLocal, attrValue) : this.eventFactory.createAttribute(attrLocal, attrValue);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
            }
            attrs.add(attribute);
        }
        events[0] = nsMap == null ? Collections.EMPTY_LIST : nsMap.values();
        events[1] = attrs == null ? Collections.EMPTY_LIST : attrs;
    }

    protected Namespace createNamespace(String prefix, String uri) {
        if (prefix == null || prefix.length() == 0) {
            return this.eventFactory.createNamespace(uri);
        }
        return this.eventFactory.createNamespace(prefix, uri);
    }
}

