/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.NameValuePair;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Property;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SDOSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SDO
implements Serializable {
    private static final long serialVersionUID = -5072361726615698930L;
    private ArrayList<SDOSignature> sdoSignatures = null;
    private SDOSignature sealSignature = null;
    private SDOSignature customPropertySignature = null;
    private String b64SignedData = null;
    private ArrayList<NameValuePair> metaDataNVPs = null;
    private ArrayList<Property> customProperties = null;

    public SDO() {
    }

    public SDO(Element element) {
        Element customPropertysignatureElem;
        Element sdosealsignatureElem;
        int i;
        NodeList nl = element.getElementsByTagName("SDOSignatures");
        if (null != nl && nl.getLength() > 0) {
            this.sdoSignatures = new ArrayList();
            Element sdosignaturesElem = (Element)nl.item(0);
            if (null != (nl = sdosignaturesElem.getElementsByTagName("SDOSignature")) && nl.getLength() > 0) {
                for (i = 0; i < nl.getLength(); ++i) {
                    this.sdoSignatures.add(new SDOSignature((Element)nl.item(i)));
                }
            }
        }
        if (null != (nl = element.getElementsByTagName("SDOSealSignature")) && nl.getLength() > 0 && null != (nl = (sdosealsignatureElem = (Element)nl.item(0)).getElementsByTagName("SDOSignature")) && nl.getLength() > 0) {
            this.sealSignature = new SDOSignature((Element)nl.item(0));
        }
        if (null != (nl = element.getElementsByTagName("CustomPropertySignature")) && nl.getLength() > 0 && null != (nl = (customPropertysignatureElem = (Element)nl.item(0)).getElementsByTagName("CustomPropertySignature")) && nl.getLength() > 0) {
            this.customPropertySignature = new SDOSignature((Element)nl.item(0));
        }
        if ((nl = element.getElementsByTagName("SignedData")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setB64SignedData(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("MetaData")).getLength() > 0) {
            this.metaDataNVPs = new ArrayList();
            NodeList childs = ((Element)nl.item(0)).getElementsByTagName("NameValuePair");
            for (i = 0; i < childs.getLength(); ++i) {
                NameValuePair nvp = new NameValuePair((Element)childs.item(i));
                this.metaDataNVPs.add(nvp);
            }
        }
    }

    public Element toXML(Document doc) {
        int i;
        Element sdoSignaturesElement;
        Element root = doc.createElement("SDO");
        if (null != this.sdoSignatures && !this.sdoSignatures.isEmpty()) {
            sdoSignaturesElement = doc.createElement("SDOSignatures");
            for (i = 0; i < this.sdoSignatures.size(); ++i) {
                sdoSignaturesElement.appendChild(this.sdoSignatures.get(i).toXML(doc));
            }
            root.appendChild(sdoSignaturesElement);
        }
        if (null != this.getSealSignature()) {
            sdoSignaturesElement = doc.createElement("SDOSealSignature");
            sdoSignaturesElement.appendChild(this.getSealSignature().toXML(doc));
            root.appendChild(sdoSignaturesElement);
        }
        if (null != this.getCustomPropertySignature()) {
            Element customProertySignaturesElement = doc.createElement("CustomPropertySignature");
            customProertySignaturesElement.appendChild(this.getCustomPropertySignature().toXML(doc));
            root.appendChild(customProertySignaturesElement);
        }
        if (null != this.getB64SignedData()) {
            Element childElement = doc.createElement("SignedData");
            childElement.appendChild(doc.createTextNode(this.getB64SignedData()));
            root.appendChild(childElement);
        }
        if (null != this.metaDataNVPs && this.metaDataNVPs.size() > 0) {
            Element metadataElement = doc.createElement("MetaData");
            for (i = 0; i < this.metaDataNVPs.size(); ++i) {
                NameValuePair nvpair = this.metaDataNVPs.get(i);
                metadataElement.appendChild(nvpair.toXML(doc));
            }
            root.appendChild(metadataElement);
        }
        if (null != this.customProperties && this.customProperties.size() > 0) {
            Element customPropertiesElement = doc.createElement("CustomProperties");
            for (i = 0; i < this.customProperties.size(); ++i) {
                Property props = this.customProperties.get(i);
                customPropertiesElement.appendChild(props.toXML(doc));
            }
            root.appendChild(customPropertiesElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public void addSDOSignature(SDOSignature sdoSig) {
        if (null == this.sdoSignatures) {
            this.sdoSignatures = new ArrayList();
        }
        if (null != sdoSig) {
            this.sdoSignatures.add(sdoSig);
        }
    }

    public void addMetaData(String key, String value) {
        if (null == this.metaDataNVPs) {
            this.metaDataNVPs = new ArrayList();
        }
        if (null != key && null != value) {
            this.metaDataNVPs.add(new NameValuePair(key, value));
        }
    }

    public ArrayList<SDOSignature> getSdoSignatures() {
        return this.sdoSignatures;
    }

    public void setSdoSignatures(ArrayList<SDOSignature> sdoSignatures) {
        this.sdoSignatures = sdoSignatures;
    }

    public SDOSignature getSealSignature() {
        return this.sealSignature;
    }

    public void setSealSignature(SDOSignature sealSignature) {
        this.sealSignature = sealSignature;
    }

    public String getB64SignedData() {
        return this.b64SignedData;
    }

    public void setB64SignedData(String signedData) {
        this.b64SignedData = signedData;
    }

    public ArrayList<NameValuePair> getMetaDataNVPs() {
        return this.metaDataNVPs;
    }

    public void setMetaDataNVPs(ArrayList<NameValuePair> metaDataNVPs) {
        this.metaDataNVPs = metaDataNVPs;
    }

    public ArrayList<Property> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(ArrayList<Property> customProperties) {
        this.customProperties = customProperties;
    }

    public SDOSignature getCustomPropertySignature() {
        return this.customPropertySignature;
    }

    public void setCustomPropertySignature(SDOSignature customPropertySignature) {
        this.customPropertySignature = customPropertySignature;
    }
}

