/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.util.ArrayList;
import java.util.List;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SignerID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Authentication {
    private static final long serialVersionUID = 8102835361981948839L;
    private String authenticationID = null;
    private boolean includeSSN = false;
    private List<SignerID> signerIDs = new ArrayList<SignerID>();

    public Authentication() {
    }

    public Authentication(Element element) {
        String includeSSNNode;
        NodeList nl = element.getElementsByTagName("AuthenticationID");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setAuthenticationID(nl.item(0).getFirstChild().getNodeValue());
        }
        if (null != (nl = element.getElementsByTagName("IncludeSSN")) && nl.getLength() > 0 && "true".equalsIgnoreCase(includeSSNNode = nl.item(0).getFirstChild().getNodeValue())) {
            this.setIncludeSSN(true);
        }
        if ((nl = element.getElementsByTagName("SignerID")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                this.addSignerID(new SignerID((Element)nl.item(i)));
            }
        }
    }

    public Element toXML(Document doc) {
        Element childElement;
        Element root = doc.createElement("Authentication");
        if (this.getAuthenticationID() != null) {
            childElement = doc.createElement("AuthenticationID");
            childElement.appendChild(doc.createTextNode(this.getAuthenticationID()));
            root.appendChild(childElement);
        }
        if (this.isIncludeSSN()) {
            childElement = doc.createElement("IncludeSSN");
            childElement.appendChild(doc.createTextNode(String.valueOf(this.isIncludeSSN())));
            root.appendChild(childElement);
        }
        for (int i = 0; i < this.signerIDs.size(); ++i) {
            root.appendChild(this.signerIDs.get(i).toXML(doc));
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public void setAuthenticationID(String authenticationID) {
        this.authenticationID = authenticationID;
    }

    public void addSignerID(SignerID signerId) {
        this.signerIDs.add(signerId);
    }

    public List<SignerID> getSignerIDs() {
        return this.signerIDs;
    }

    public void setSignerIDs(SignerID signerID) {
        this.signerIDs.clear();
        this.signerIDs.add(signerID);
    }

    public boolean isIncludeSSN() {
        return this.includeSSN;
    }

    public void setIncludeSSN(boolean includeSSN) {
        this.includeSSN = includeSSN;
    }
}

