/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages;

import java.io.Serializable;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import no.bbs.tt.trustsign.tsm.xml.util.DateUtility;
import no.bbs.tt.trustsign.tsm.xml.util.SecureDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TrustSignMessage
implements Serializable {
    private static final long serialVersionUID = 2391972857086605870L;
    protected static String ENCODING = "UTF-8";
    protected Document doc = null;
    protected String namespace = null;
    protected String schemaLocation;
    private String orderID;
    private String transRef;
    private Date time;
    private String type;
    private long merchantID = -1L;
    private String messageID = null;
    private String additionalInfo;

    protected TrustSignMessage() {
    }

    protected TrustSignMessage(Document document) {
        NodeList nl;
        NamedNodeMap nodeAttributes;
        Element root = document.getDocumentElement();
        if (root != null && (nodeAttributes = root.getAttributes()) != null) {
            Node defaultNSNode;
            Node schemalocationNode = nodeAttributes.getNamedItem("xsi:schemaLocation");
            if (null != schemalocationNode) {
                this.schemaLocation = schemalocationNode.getNodeValue();
            }
            if (null != (defaultNSNode = nodeAttributes.getNamedItem("xmlns"))) {
                String ns = defaultNSNode.getNodeValue();
                if (null == ns) {
                    ns = document.getNamespaceURI();
                }
                if (null == ns) {
                    ns = root.getNamespaceURI();
                }
                this.setNamespace(ns);
            }
        }
        if ((nl = document.getElementsByTagName("MerchantID")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setMerchantID(Long.parseLong(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = document.getElementsByTagName("Time")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            String time = nl.item(0).getFirstChild().getNodeValue();
            Date creationTimeInput = DateUtility.XMLToDate(time);
            this.setTime(creationTimeInput);
        }
        if ((nl = document.getElementsByTagName("MessageID")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setMessageID(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = document.getElementsByTagName("AdditionalInfo")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setAdditionalInfo(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public abstract boolean isTransactional();

    public Document toXML() {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = SecureDocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unable to create document builder :" + e.getMessage(), e);
        }
        this.doc = dBuilder.newDocument();
        Element element = this.doc.createElement("TrustSignMessage");
        this.doc.appendChild(element);
        Element root = (Element)this.doc.getFirstChild();
        if (null != this.getNamespace()) {
            root.setAttribute("xmlns", this.getNamespace());
        }
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (null != this.getSchemaLocation()) {
            root.setAttribute("xsi:schemaLocation", this.getSchemaLocation());
        }
        Element childElement = this.doc.createElement("MerchantID");
        childElement.appendChild(this.doc.createTextNode("" + this.getMerchantID()));
        root.appendChild(childElement);
        if (this.getTime() != null) {
            childElement = this.doc.createElement("Time");
            childElement.appendChild(this.doc.createTextNode(DateUtility.DateToXML(this.getTime())));
            root.appendChild(childElement);
        }
        if (this.getMessageID() != null) {
            childElement = this.doc.createElement("MessageID");
            childElement.appendChild(this.doc.createTextNode(this.getMessageID()));
            root.appendChild(childElement);
        }
        if (this.getAdditionalInfo() != null) {
            childElement = this.doc.createElement("AdditionalInfo");
            childElement.appendChild(this.doc.createTextNode(this.getAdditionalInfo()));
            root.appendChild(childElement);
        }
        return this.doc;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getOrderID() {
        return this.orderID;
    }

    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public String getTransRef() {
        return this.transRef;
    }

    public void setTransRef(String transRef) {
        this.transRef = transRef;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getMerchantID() {
        return this.merchantID;
    }

    public void setMerchantID(long merchantID) {
        this.merchantID = merchantID;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }
}

