/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.ReminderSettings;
import no.bbs.tt.trustsign.tsm.xml.util.DateUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SigningProcessStatus
implements Serializable {
    private static final long serialVersionUID = -464472936387696386L;
    private String localDocumentReferance = null;
    private List<String> localAttachmentReferences = null;
    private String localSignerReferance = null;
    private String status = null;
    private Date timestamp = null;
    private String signingPKI = null;
    private String rejectText = null;

    public SigningProcessStatus() {
    }

    public SigningProcessStatus(String localDocumentReferance, String localSignerReferance, List<String> localAttachmentReferences, String localWebContextRef, boolean terminateOrderOnRejection, ReminderSettings reminderSettings) {
        this.localDocumentReferance = localDocumentReferance;
        this.localSignerReferance = localSignerReferance;
        this.localAttachmentReferences = localAttachmentReferences;
    }

    public SigningProcessStatus(Element element) {
        NodeList attachmentRefs;
        NodeList nl = element.getElementsByTagName("LocalDocumentReference");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setLocalDocumentReferance(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("LocalSignerReference")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setLocalSignerReferance(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("LocalAttachmentReferences")).getLength() > 0 && null != (attachmentRefs = element.getElementsByTagName("LocalAttachmentReference")) && attachmentRefs.getLength() > 0) {
            this.localAttachmentReferences = new ArrayList<String>();
            for (int i = 0; i < attachmentRefs.getLength(); ++i) {
                this.localAttachmentReferences.add(attachmentRefs.item(i).getFirstChild().getNodeValue());
            }
            this.setLocalAttachmentReferences(this.localAttachmentReferences);
        }
        if ((nl = element.getElementsByTagName("Status")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setStatus(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("RejectText")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setRejectText(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("Timestamp")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            String time = nl.item(0).getFirstChild().getNodeValue();
            this.setTimestamp(DateUtility.XMLToDate(time));
        }
        if ((nl = element.getElementsByTagName("SigningPKI")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setSigningPKI(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public Element toXML(Document doc) {
        Element signerRefElement;
        Element childElement;
        Element root = doc.createElement("SigningProcessStatus");
        if (null != this.getLocalDocumentReferance()) {
            childElement = doc.createElement("LocalDocumentReference");
            childElement.appendChild(doc.createTextNode(this.getLocalDocumentReferance()));
            root.appendChild(childElement);
        }
        if (null != this.getLocalSignerReferance()) {
            signerRefElement = doc.createElement("LocalSignerReference");
            signerRefElement.appendChild(doc.createTextNode(this.getLocalSignerReferance()));
            root.appendChild(signerRefElement);
        }
        if (null != this.getLocalAttachmentReferences()) {
            Element attachRoot = doc.createElement("LocalAttachmentReferences");
            for (int i = 0; i < this.localAttachmentReferences.size(); ++i) {
                Element childElement2 = doc.createElement("LocalAttachmentReference");
                childElement2.appendChild(doc.createTextNode(this.getLocalAttachmentReferences().get(i)));
                attachRoot.appendChild(childElement2);
            }
            root.appendChild(attachRoot);
        }
        if (null != this.getStatus()) {
            signerRefElement = doc.createElement("Status");
            signerRefElement.appendChild(doc.createTextNode(this.getStatus()));
            root.appendChild(signerRefElement);
        }
        if (null != this.getRejectText()) {
            signerRefElement = doc.createElement("RejectText");
            signerRefElement.appendChild(doc.createTextNode(this.getRejectText()));
            root.appendChild(signerRefElement);
        }
        if (null != this.getTimestamp()) {
            childElement = doc.createElement("Timestamp");
            childElement.appendChild(doc.createTextNode(DateUtility.DateToXML(this.getTimestamp())));
            root.appendChild(childElement);
        }
        if (null != this.getSigningPKI()) {
            childElement = doc.createElement("SigningPKI");
            childElement.appendChild(doc.createTextNode(this.getSigningPKI()));
            root.appendChild(childElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public String getLocalDocumentReferance() {
        return this.localDocumentReferance;
    }

    public void setLocalDocumentReferance(String localDocumentReferance) {
        this.localDocumentReferance = localDocumentReferance;
    }

    public List<String> getLocalAttachmentReferences() {
        return this.localAttachmentReferences;
    }

    public void setLocalAttachmentReferences(List<String> localAttachmentReferences) {
        this.localAttachmentReferences = localAttachmentReferences;
    }

    public String getLocalSignerReferance() {
        return this.localSignerReferance;
    }

    public void setLocalSignerReferance(String localSignerReferance) {
        this.localSignerReferance = localSignerReferance;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getSigningPKI() {
        return this.signingPKI;
    }

    public void setSigningPKI(String signingPKI) {
        this.signingPKI = signingPKI;
    }

    public String getRejectText() {
        return this.rejectText;
    }

    public void setRejectText(String rejectText) {
        this.rejectText = rejectText;
    }
}

