/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import no.bbs.tt.trustsign.tsm.xml.messages.containers.IDocType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PDF
implements IDocType {
    private static final long serialVersionUID = 8687339171400724716L;
    private String b64DocumentBytesAsString = null;
    private boolean isPDFForm = false;
    private String formInstructions = null;

    public PDF() {
    }

    public PDF(String b64DocumentBytesAsString) {
        this.b64DocumentBytesAsString = b64DocumentBytesAsString;
    }

    public PDF(Element element) {
        String isForm;
        NodeList nl = element.getElementsByTagName("Form");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null && "true".equalsIgnoreCase(isForm = nl.item(0).getFirstChild().getNodeValue())) {
            this.setPDFForm(true);
            nl = element.getElementsByTagName("FormInstructions");
            if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setFormInstructions(nl.item(0).getFirstChild().getNodeValue());
            }
        }
        if ((nl = element.getElementsByTagName("B64DocumentBytes")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setB64DocumentBytesAsString(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    @Override
    public Element toXML(Document doc) {
        Element root = doc.createElement("PDF");
        if (this.isPDFForm) {
            Element formElement = doc.createElement("Form");
            formElement.appendChild(doc.createTextNode("true"));
            root.appendChild(formElement);
            if (null != this.formInstructions) {
                Element formInstructionsElement = doc.createElement("FormInstructions");
                formInstructionsElement.appendChild(doc.createTextNode(this.formInstructions));
                root.appendChild(formInstructionsElement);
            }
        }
        if (null != this.getB64DocumentBytesAsString()) {
            Element childElement = doc.createElement("B64DocumentBytes");
            childElement.appendChild(doc.createTextNode(this.getB64DocumentBytesAsString()));
            root.appendChild(childElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    @Override
    public String getB64DocumentBytesAsString() {
        return this.b64DocumentBytesAsString;
    }

    @Override
    public String getMimeType() {
        return "PDF";
    }

    @Override
    public void setB64DocumentBytesAsString(String b64DocumentBytesAsString) {
        this.b64DocumentBytesAsString = b64DocumentBytesAsString;
    }

    public boolean isPDFForm() {
        return this.isPDFForm;
    }

    public void setPDFForm(boolean isPDFForm) {
        this.isPDFForm = isPDFForm;
    }

    public String getFormInstructions() {
        return this.formInstructions;
    }

    public void setFormInstructions(String formInstructions) {
        this.formInstructions = formInstructions;
    }
}

