/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Email;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Fax;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.IChannel;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SMS;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.XMLService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NotificationChannel
implements Serializable {
    private static final long serialVersionUID = 5266651666041375369L;
    private IChannel channel = null;
    private ArrayList<String> triggers = null;

    public NotificationChannel() {
    }

    public NotificationChannel(IChannel c) {
        this.channel = c;
    }

    public NotificationChannel(Element element) {
        NodeList nl = element.getElementsByTagName("Channel");
        if (nl.getLength() > 0) {
            Element endpointELem = (Element)nl.item(0);
            if ((nl = endpointELem.getElementsByTagName("Email")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setChannel(new Email((Element)nl.item(0)));
            }
            if ((nl = endpointELem.getElementsByTagName("SMS")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setChannel(new SMS((Element)nl.item(0)));
            }
            if ((nl = endpointELem.getElementsByTagName("Fax")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setChannel(new Fax((Element)nl.item(0)));
            }
            if ((nl = endpointELem.getElementsByTagName("XMLService")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setChannel(new XMLService((Element)nl.item(0)));
            }
        }
        if (null != (nl = element.getElementsByTagName("Triggers")) && nl.getLength() > 0) {
            this.triggers = new ArrayList();
            Element triggersElem = (Element)nl.item(0);
            NodeList triggerElements = triggersElem.getElementsByTagName("Trigger");
            if (null != triggerElements && triggerElements.getLength() > 0) {
                for (int i = 0; i < triggerElements.getLength(); ++i) {
                    String trigger = triggerElements.item(i).getFirstChild().getNodeValue();
                    if (this.triggers.contains(trigger)) continue;
                    this.triggers.add(trigger);
                }
            }
        }
    }

    public Element toXML(Document doc) {
        Element root = doc.createElement("NotificationChannel");
        if (null != this.getChannel()) {
            Element epElement;
            String channelType = this.getChannel().getType();
            if ("Email".equals(channelType)) {
                epElement = doc.createElement("Channel");
                epElement.appendChild(this.getChannel().toXML(doc));
                root.appendChild(epElement);
            }
            if ("SMS".equals(channelType)) {
                epElement = doc.createElement("Channel");
                epElement.appendChild(this.getChannel().toXML(doc));
                root.appendChild(epElement);
            }
            if ("FAX".equals(channelType)) {
                epElement = doc.createElement("Channel");
                epElement.appendChild(this.getChannel().toXML(doc));
                root.appendChild(epElement);
            }
            if ("XML".equals(channelType)) {
                epElement = doc.createElement("Channel");
                epElement.appendChild(this.getChannel().toXML(doc));
                root.appendChild(epElement);
            }
        }
        if (null != this.triggers && !this.triggers.isEmpty()) {
            Element triggersElement = doc.createElement("Triggers");
            for (int i = 0; i < this.triggers.size(); ++i) {
                String currTrigger = this.triggers.get(i);
                Element triggerElement = doc.createElement("Trigger");
                triggerElement.appendChild(doc.createTextNode(currTrigger));
                triggersElement.appendChild(triggerElement);
            }
            root.appendChild(triggersElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public void setChannel(IChannel c) {
        this.channel = c;
    }

    public ArrayList<String> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(ArrayList<String> triggers) {
        this.triggers = triggers;
    }

    public void addTrigger(String trigger) {
        if (null == this.triggers) {
            this.triggers = new ArrayList();
        }
        if (!this.triggers.contains(trigger)) {
            this.triggers.add(trigger);
        }
    }
}

