/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.util.ArrayList;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.IPKI;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SignerID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BankIDNOMobile
implements IPKI {
    private static final long serialVersionUID = -3397831892857194145L;
    private boolean includeSSN = false;
    private ArrayList<String> certificatePolicies = new ArrayList();
    private ArrayList<SignerID> signerIDs = new ArrayList();

    public BankIDNOMobile() {
    }

    public BankIDNOMobile(Element element) {
        String includeSSNNode;
        NodeList nl = element.getElementsByTagName("IncludeSSN");
        if (null != nl && nl.getLength() > 0 && "true".equalsIgnoreCase(includeSSNNode = nl.item(0).getFirstChild().getNodeValue())) {
            this.setIncludeSSN(true);
        }
        if (null != (nl = element.getElementsByTagName("CertificatePolicy")) && nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                this.addCertificatePolicy(nl.item(i).getFirstChild().getNodeValue());
            }
        }
        if ((nl = element.getElementsByTagName("SignerID")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                this.addSignerID(new SignerID((Element)nl.item(i)));
            }
        }
    }

    @Override
    public Element toXML(Document doc) {
        Element root = doc.createElement("BankIDNOMobile");
        if (this.isIncludeSSN()) {
            Element childElement = doc.createElement("IncludeSSN");
            childElement.appendChild(doc.createTextNode(String.valueOf(this.isIncludeSSN())));
            root.appendChild(childElement);
        }
        if (!this.getCertificatePolicies().isEmpty()) {
            for (int i = 0; i < this.getCertificatePolicies().size(); ++i) {
                Element childElement = doc.createElement("CertificatePolicy");
                childElement.appendChild(doc.createTextNode(this.getCertificatePolicies().get(i)));
                root.appendChild(childElement);
            }
        }
        for (int i = 0; i < this.signerIDs.size(); ++i) {
            root.appendChild(this.signerIDs.get(i).toXML(doc));
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    @Override
    public ArrayList<String> getCertificatePolicies() {
        return this.certificatePolicies;
    }

    public void addCertificatePolicy(String certificatePolicy) {
        this.certificatePolicies.add(certificatePolicy);
    }

    @Override
    public ArrayList<SignerID> getSignerIDs() {
        return this.signerIDs;
    }

    public void addSignerID(SignerID signerId) {
        this.signerIDs.add(signerId);
    }

    @Override
    public SignerID getSignerID() {
        if (this.signerIDs.size() > 0) {
            return this.signerIDs.get(0);
        }
        return null;
    }

    public void setSignerID(SignerID signerID) {
        this.signerIDs.clear();
        this.signerIDs.add(signerID);
    }

    @Override
    public String getPKIVendor() {
        return "BankIDNOMobile";
    }

    public boolean isIncludeSSN() {
        return this.includeSSN;
    }

    public void setIncludeSSN(boolean includeSSN) {
        this.includeSSN = includeSSN;
    }
}

