/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages;

import no.bbs.tt.trustsign.tsm.xml.messages.BaseRequestMessage;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.IDocType;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.PDF;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Text;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MerchantSignDocumentRequest
extends BaseRequestMessage {
    private String description;
    private IDocType docType;
    private String merchantSigningPKIType;

    public MerchantSignDocumentRequest() {
    }

    public MerchantSignDocumentRequest(Document doc) {
        super("MerchantSignDocument", doc);
        NodeList nl;
        this.setType("MerchantSignDocument");
        NodeList documentElements = doc.getElementsByTagName("Document");
        if (null != documentElements && documentElements.getLength() > 0) {
            Element element = (Element)documentElements.item(0);
            NodeList nl2 = element.getElementsByTagName("Description");
            if (nl2.getLength() > 0 && nl2.item(0).getFirstChild() != null) {
                this.setDescription(nl2.item(0).getFirstChild().getNodeValue());
            }
            if (null != (nl2 = element.getElementsByTagName("DocType")) && nl2.getLength() > 0) {
                Element docTypeELem = (Element)nl2.item(0);
                if ((nl2 = docTypeELem.getElementsByTagName("PDF")).getLength() > 0 && nl2.item(0).getFirstChild() != null) {
                    this.setDocType(new PDF((Element)nl2.item(0)));
                }
                if ((nl2 = docTypeELem.getElementsByTagName("TEXT")).getLength() > 0 && nl2.item(0).getFirstChild() != null) {
                    this.setDocType(new Text((Element)nl2.item(0)));
                }
                if ((nl2 = docTypeELem.getElementsByTagName("XML")).getLength() > 0 && nl2.item(0).getFirstChild() != null) {
                    this.setDocType(new XML((Element)nl2.item(0)));
                }
            }
        }
        if ((nl = doc.getElementsByTagName("SigningPKIType")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.merchantSigningPKIType = nl.item(0).getFirstChild().getNodeValue();
        }
    }

    @Override
    public Document toXML() {
        Document doc = super.toXML();
        Element root = this.toXMLHeader("MerchantSignDocument", doc);
        Element documentElement = doc.createElement("Document");
        Element descElement = doc.createElement("Description");
        descElement.appendChild(doc.createTextNode(this.description));
        documentElement.appendChild(descElement);
        Element docTypeElement = doc.createElement("DocType");
        docTypeElement.appendChild(this.docType.toXML(doc));
        documentElement.appendChild(docTypeElement);
        root.appendChild(documentElement);
        Element signingPkiTypeElement = doc.createElement("SigningPKIType");
        signingPkiTypeElement.appendChild(doc.createTextNode(this.merchantSigningPKIType));
        root.appendChild(signingPkiTypeElement);
        doc.getFirstChild().appendChild(root);
        return doc;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMerchantSigningPKIType() {
        return this.merchantSigningPKIType;
    }

    public void setMerchantSigningPKIType(String merchantSigningPKIType) {
        this.merchantSigningPKIType = merchantSigningPKIType;
    }

    public IDocType getDocType() {
        return this.docType;
    }

    public void setDocType(IDocType docType) {
        this.docType = docType;
    }
}

